<?php
/**
* Fuel Theme
* Version 5.0.0
*/

$logo = apply_shortcodes('[svg id="logo"]'); // If logo in theme images folder $logo = '<img src="'.get_stylesheet_directory_uri().'/images/logo.png" alt="" width="" height="" />';
?>

</main>

<footer class="footer">

	<div class="contain footer-blocks">
		<nav class="footer-block footer-branding">
			<?php echo '<a href="'.home_url('/').'" class="footer-logo" aria-label="'.apply_shortcodes('[company format="<company>"]').' Home">'.$logo.'</a>'; ?>
			<?php echo has_nav_menu('social') ? wp_nav_menu(array('theme_location'=>'social', 'menu_class'=>'footer-social', 'echo'=>false, 'container' => false)) : ''; ?>
		</nav>

		<div class="footer-block footer-locations">
			<h3 class="footer-title">Our Locations</h3>
			<?php if(wp_count_posts('location')->publish>4){
				echo '<ul class="footer-locations-list">';
				echo fuelCUSTOMLOOP('[custom_loop type="location" orderby="menu_order" order="ASC"]
					<li><a href="{permalink}">{post_title}</a></li>
				[/custom_loop]');
				echo '</ul>';
			} else {
				echo '<div class="footer-locations-wrapper">';
				echo fuelCUSTOMLOOP('[custom_loop type="location" orderby="menu_order" order="ASC"]
					<div class="footer-location">
						<h4 class="footer-loc-title">[company location="{ID}"]</h4>
						<p>[address location="{ID}" svg="marker" class="icon-item"]</p>
						<p>[phone location="{ID}" svg="phone" class="icon-item"]</p>
						<p>[hours location="{ID}" svg="clock" class="icon-item"]</p>
					</div>
				[/custom_loop]');
				echo '</div>';
			} ?>
		</div>

		<nav class="footer-block footer-links">
			<h3 class="footer-title">Quick Links</h3>
			<?php echo has_nav_menu('footer') ? wp_nav_menu(array('theme_location'=>'footer', 'menu_class'=>'footer-menu', 'echo'=>false, 'container' => false)) : ''; ?>
		</nav>
	</div>

	<div class="contain footer-end">
		<div class="copyright">Copyright &copy; <?php echo date('Y'); ?> <?php echo apply_shortcodes('[company]'); ?>. All Rights Reserved.</div>
		<?php echo has_nav_menu('policy') ? '<nav class="policy-nav">'.wp_nav_menu(array('theme_location'=>'policy', 'menu_class'=>'policy-menu', 'echo'=>false, 'container' => false)).'</nav>' : ''; ?>
	</div>

</footer>

<?php get_template_part('foot'); ?>
